package gov.va.med.mhv.integration.phr.stage.transfer;

import org.apache.commons.lang3.StringUtils;


/**
 * 
 *	ALTER TABLE PHR_CHEM_LAB ADD "REPORT_TEXT" CLOB;
 *	ALTER TABLE PHR_CHEM_LAB ADD "COMPLETED_ON_DATE_PRECISE" TIMESTAMP (6);
 *	ALTER TABLE PHR_CHEM_LAB ADD "COMPLETED_ON_DATE_IMPRECISE" TIMESTAMP (6);
 *	ALTER TABLE PHR_CHEM_LAB ADD "COLLECTION_SAMPLE" VARCHAR2(255 CHAR);	
 *
 * @see StageMicrobiology
 * @author vhaiswgrahak
 *
 */
public class StageMicrobiology extends StageChemistry  {

	private String reportText;
	private String collectionSample;
	
	public String getReportText() {
		return reportText;
	}
	public void setReportText(String reportText) {
		this.reportText = reportText;
	}
 	public String getCollectionSample() {
		return collectionSample;
	}
	public void setCollectionSample(String collectionSample) {
		this.collectionSample = collectionSample;
	}

	public void setAK(StageEntityAK ak) {
		this.icn = ak.getIcn();
		// Station number is excluded because it comes from the response not the
		// request
		// in the case of immunization.

		// this.stationNumber=ak.getStationNumber();
		this.requestMsgCtrlId = ak.getRequestMsgCtrlId();
		this.responseMsgCtrlId = ak.getResponseMsgCtrlId();
	}
	
	public String toCompare() {
		return ""+
				getAmendedStatus()+
				getCollectedOnDatePrecise()+
				StringUtils.deleteWhitespace(getComments())+
				getExtractStatus()+
				getInterpretation()+
				getLabTestName()+
				getLabType()+
				getOrderedTest()+
				getOrderingLocation()+
				getOrderingProvider()+
				getPerformingLocation()+
				getPerformingLocationName()+
				getRecordId()+
				getReferenceRange()+
				getReportCompleteDatePrecise()+
				getResult()+
				getResultIndicator()+
				getSpecimenSource()+
				getStatus()+
				getUnits()+
				getCollectionSample()+
				StringUtils.deleteWhitespace(getReportText());
	}
}
